//
//  MutableKey.h
//  Keychain
//
//  Created by Wade Tregaskis on Sat Mar 15 2003.
//  Copyright (c) 2003 Wade Tregaskis. All rights reserved.
//

#import "Key.h"
#import "CSSMControl.h"


@interface MutableKey : Key {
    CSSM_KEY *MutableCSSMKey;
    BOOL freeWhenDone;
}

+ (MutableKey*)generateKey:(CSSM_ALGORITHMS)algorithm size:(uint32)keySizeInBits validFrom:(NSCalendarDate*)validFrom validTo:(NSCalendarDate*)validTo usage:(uint32)keyUsage mutable:(BOOL)keyIsMutable extractable:(BOOL)keyIsExtractable label:(NSString*)label;

+ (MutableKey*)keyWithKeyRef:(SecKeyRef)ke;
+ (MutableKey*)keyWithCSSMKey:(CSSM_KEY *)ke;
+ (MutableKey*)keyWithCSSMKey:(CSSM_KEY *)ke freeWhenDone:(BOOL)freeWhenDo;

- (MutableKey*)initWithKeyRef:(SecKeyRef)ke;
- (MutableKey*)initWithCSSMKey:(CSSM_KEY *)ke freeWhenDone:(BOOL)freeWhenDo;

- (void)setFreeWhenDone:(BOOL)freeWhenDo;
- (BOOL)freeWhenDone;

- (CSSM_KEY *)CSSMKey;

@end

NSArray* generateKeyPair(CSSM_ALGORITHMS algorithm, uint32 keySizeInBits, NSCalendarDate *validFrom, NSCalendarDate *validTo, uint32 publicKeyUsage, uint32 privateKeyUsage, BOOL publicKeyIsMutable, BOOL privateKeyIsMutable, BOOL publicKeyIsExtractable, BOOL privateKeyIsExtractable, NSString *publicKeyLabel, NSString *privateKeyLabel);
